  /*
   *  Object %name    : parser_atp_sst_data.c%
   *  State           :  %state%
   *  Creation date   :  Apr 06 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the DH parsing functions  
   *
   *  \version parser_atp_sst_data.c#1:csrc:1
   *  \author  taniam
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************* Include Files ****************/
#include "SST_SEP_ATP_Data.h"
#include "SST_SEP_ATP_ReadOnlyData.h"
#include"parser_atp_sst_data.h"
#include "sep_utils.h"
/************************ Global Data ************************/
    extern DxByte_t*                               TST_Workspace;
    extern DxUint32_t                              TST_WorkspaceSizeInBytes ;
    extern DxUint8_t*                              GlobalMemBuff;
    extern DxUint8_t*                              CurrGlobalMemBuff;
    extern   TST_ATP_DataOpTestDataStruct*         TST_ATP_DataOpTestData;
    TST_ATP_BindingWritingPermissionsStruct*       TST_ATP_BindingWritingPermissionsTestData;
/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_BasicDataOp
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_SST_BasicDataOp
* function and calls the SEP function.
* 
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/
DxUint32_t DX_SEP_SST_PARSER_BasicDataOp(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t  SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_DataOpTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_DataOpTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_DataOpTestData = (TST_ATP_DataOpTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_DataOpTestDataStruct);
    }

    /* 4. extract parameters from the message */
    /******************************************/
    DX_VOS_FastMemCpy(&TST_ATP_DataOpTestData[0], 
                      &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET],
                      sizeof(TST_ATP_DataOpTestDataStruct));

    /*5. call QA SEP function */
    SEP_Error = SEPQA_SST_BasicDataOp();

    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_BasicDataOp test");
    
End:
      /*6. free allocated GlobalMemBuff */
    DX_VOS_MemFree(GlobalMemBuff);

    /* 7. end SEP message and return */
    /**********************/
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_BasicDataOp_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}
/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_BasicUnAuthnticatedDataOp
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_SST_BasicUnAuthnticatedDataOp
* function and calls the SEP function.
*
* Algorithm:
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/
DxUint32_t DX_SEP_SST_PARSER_BasicUnAuthnticatedDataOp(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t  SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_DataOpTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_DataOpTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_DataOpTestData = (TST_ATP_DataOpTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_DataOpTestDataStruct);
    }

    /* 4. extract parameters from the message */
    DX_VOS_FastMemCpy(&TST_ATP_DataOpTestData[0],
                      &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET],
                      sizeof(TST_ATP_DataOpTestDataStruct));

    /*5. call QA SEP function */
    SEP_Error = SEPQA_SST_BasicUnAuthnticatedDataOp();

    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_BasicDataOp test");

  End:
    /*6. free allocated GlobalMemBuff */
    DX_VOS_MemFree(GlobalMemBuff);

    /*7. end SEP message and return */
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_BasicUnAuthnticatedDataOp_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}

/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_BindingWritingPermissions
*
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_SST_BindingWritingPermissions
* function and calls the SEP function.
*
* Algorithm:
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/
DxUint32_t DX_SEP_SST_PARSER_BindingWritingPermissions(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t  SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_BindingWritingPermissionsStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_BindingWritingPermissionsTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_BindingWritingPermissionsTestData = (TST_ATP_BindingWritingPermissionsStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_BindingWritingPermissionsStruct);
    }

    /* 4. extract parameters from the message */
    DX_VOS_FastMemCpy(&TST_ATP_BindingWritingPermissionsTestData[0], 
                      &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET],
                      sizeof(TST_ATP_BindingWritingPermissionsStruct));


    /*5. call QA SEP function */
    SEP_Error = SEPQA_SST_BindingWritingPermissions();

    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_TST_ATP_BindingWritingPermissionsTestData test");

End:
    /*6. free allocated GlobalMemBuff */
    DX_VOS_MemFree(GlobalMemBuff);

    /*7. end SEP message and return */
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_BindingWritingPermissions_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}
/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_DataReplace
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_SST_DataReplace
* function and calls the SEP function.
*
* Algorithm:
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/

DxUint32_t DX_SEP_SST_PARSER_DataReplace(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxError_t  SEP_Error=0;

    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                 &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
    {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
    }

    /* 2. call QA SEP function */
    SEP_Error = SEPQA_SST_DataReplace();
    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_DataReplace");


End:
    /* 3. end SEP message and return */
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_DataReplace_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}

/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_ReadOnlyData
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_SST_ReadOnlyData
* function and calls the SEP function.
*
* Description:
* 
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/ 

DxUint32_t DX_SEP_SST_PARSER_ReadOnlyData(DxUint32_t* msg)
{

    /********* Variables Definitions ************/
    DxUint32_t  SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;


    /*1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
     SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                  &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
    {
       TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
      goto End;
    }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_DataOpTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_DataOpTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_DataOpTestData = (TST_ATP_DataOpTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_DataOpTestDataStruct);
    }

    /* 4. extract parameters from the message */
    /******************************************/
    DX_VOS_FastMemCpy(&TST_ATP_DataOpTestData[0], 
                      &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET],
                      sizeof(TST_ATP_DataOpTestDataStruct));


      /*5. call QA SEP function */
      SEP_Error = SEPQA_SST_ReadOnlyData();

    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_ReadOnlyData test");
    
End:
    /*6. end SEP message and return */
    DX_VOS_MemFree(GlobalMemBuff);

    /*7. end SEP message and return */
    /**********************/
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_ReadOnlyData_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}
